---
layout: default
published: true
title: CLI Command Reference
nav_order: 2
---

# CLI Command Reference

| Parameter                                                                                                                                                                                                                                                                                                                                                                  | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `-h, --help`                                                                                                                                                                                                                                                                                                                                                               | Show a help message and exit                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| `-v, --version`                                                                                                                                                                                                                                                                                                                                                            | Version                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `-d, --directory DIRECTORY`                                                                                                                                                                                                                                                                                                                                                | IaC root directory (can not be used together with `--file`).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| `--add-check`                                                                                                                                                                                                                                                                                                                                                              | Generate a new check via CLI prompt                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `-f, --file FILE`                                                                                                                                                                                                                                                                                                                                                          | File to scan (can not be used together with `--directory`). With this option, Checkov will attempt to filter the runners based on the file type. For example, if you specify a ".tf" file, only the terraform and secrets frameworks will be included. You can further limit this (e.g., skip secrets) by using the `--skip-framework` argument.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| `--skip-path SKIP_PATH`                                                                                                                                                                                                                                                                                                                                                    | Path (file or directory) to skip, using regular expression logic, relative to the current working directory. Word boundaries are not implicit; i.e., specifying "dir1" will skip any directory or subdirectory named "dir1". Ignored with `-f`. Can be specified multiple times.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| `--external-checks-dir EXTERNAL_CHECKS_DIR`                                                                                                                                                                                                                                                                                                                                | Directory for custom checks to be loaded. Can be repeated                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `--external-checks-git EXTERNAL_CHECKS_GIT`                                                                                                                                                                                                                                                                                                                                | GitHub URL of external checks to be added. you can specify a subdirectory after a double-slash //. possible to use ?ref=tags/tagName or ?ref=heads/branchName or ?ref=commit_id. Cannot be used together with `--external-checks-dir`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `-l, --list`                                                                                                                                                                                                                                                                                                                                                               | List checks                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `-o, --output` {`cli`, `csv`, `cyclonedx`, `cyclonedx_json`, `spdx`, `json`, `junitxml`, `github_failed_only`, `gitlab_sast`, `sarif`}                                                                                                                                                                                                                                     | Report output format. Add multiple outputs by using the flag multiple times (`-o sarif -o cli`)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `--output-file-path OUTPUT_FILE_PATH`                                                                                                                                                                                                                                                                                                                                      | Name of the output folder to save the chosen output formats. Advanced usage: By using `-o cli -o junitxml --output-file-path console,results.xml` the CLI output will be printed to the console and the JunitXML output to the file results.xml.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| `--output-bc-ids`                                                                                                                                                                                                                                                                                                                                                          | Print Bridgecrew platform IDs (BC...) instead of Checkov IDs (CKV...), if the check exists in the platform                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `--include-all-checkov-policies`                                                                                                                                                                                                                                                                                                                                           | When running with an API key, Checkov will omit any policies that do not exist in Prisma Cloud platform, except for local custom policies loaded with the `--external-check` flags. Use this key to include policies that only exist in Checkov in the scan. Note that this will make the local CLI results different from the results you see in the platform. Has no effect if you are not using an API key. Use the `--check` option to explicitly include checks by ID even if they are not in the platform, without using this flag.                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `--quiet`                                                                                                                                                                                                                                                                                                                                                                  | For the CLI output, display only failed checks. Also disables progress bars.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| `--compact`                                                                                                                                                                                                                                                                                                                                                                | For the CLI output, do not display code blocks.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `--framework` {`bitbucket_pipelines`, `argo_workflows`, `arm`, `bicep`, `cloudformation`, `dockerfile`, `github_configuration`, `github_actions`, `gitlab_configuration`, `gitlab_ci`, `bitbucket_configuration`, `helm`, `json`, `yaml`, `kubernetes`, `kustomize`, `openapi`, `sca_package`, `sca_image`, `secrets`, `serverless`, `terraform`, `terraform_plan`, `all`} | Filter scan to run only on specific infrastructure code frameworks [env var: CKV_FRAMEWORK]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `--skip-framework` {`bitbucket_pipelines`, `argo_workflows`, `arm`, `bicep`, `cloudformation`, `dockerfile`, `github_configuration`, `github_actions`, `gitlab_configuration`, `gitlab_ci`, `bitbucket_configuration`, `helm`, `json`, `yaml`, `kubernetes`, `kustomize`, `openapi`, `sca_package`, `sca_image`, `secrets`, `serverless`, `terraform`, `terraform_plan`}   | Filter scan to skip specific infrastructure as code frameworks. This will be included automatically for some frameworks if system dependencies are missing. Add multiple frameworks using spaces. For example, "`--skip-framework terraform sca_package`."                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `-c, --check CHECK`                                                                                                                                                                                                                                                                                                                                                        | Checks to run; any other checks will be skipped. Enter one or more items separated by commas. Each item may be either a Checkov check ID (CKV_AWS_123), a BC check ID (BC_AWS_GENERAL_123), or a severity (LOW, MEDIUM, HIGH, CRITICAL). If you use a severity, then all checks equal to or above the lowest severity in the list will be included. This option can be combined with `--skip-check`. If it is, priority is given to checks explicitly listed by ID or wildcard over checks listed by severity. For example, if you use `--check CKV_123` and `--skip-check LOW`, then CKV_123 will run even if it is a LOW severity. In the case of a tie (e.g., `--check MEDIUM` and `--skip-check HIGH` for a medium severity check), then the check will be skipped. If you use a check ID here along with an API key, and the check is not part of the BC / PC platform, then the check will still be run (see `--include-all-checkov-policies` for more info). [env var: CKV_CHECK] |
| `--skip-check SKIP_CHECK`                                                                                                                                                                                                                                                                                                                                                  | Checks to skip; any other checks will not be run. Enter one or more items separated by commas. Each item may be either a Checkov check ID (CKV_AWS_123), a BCcheck ID (BC_AWS_GENERAL_123), a severity (LOW, MEDIUM, HIGH, CRITICAL), or a secret validation status (Invalid). If you use a severity, then all checks equal to or below the highest severity in the list will be skipped. This option can be combined with `--check`. If it is, priority is given to checks explicitly listed by ID or wildcard over checks listed by severity. For example, if you use `--skip-check CKV_123` and `--check HIGH`, then CKV_123 will be skipped even if it is a HIGH severity. In the case of a tie(e.g., `--check MEDIUM` and `--skip-check HIGH` for a medium severity check), then the check will be skipped. [env var: CKV_SKIP_CHECK]                                                                                                                                               |
| `--run-all-external-checks`                                                                                                                                                                                                                                                                                                                                                | Run all external checks (loaded via `--external-checks` options) even if the checks are not present in the `--check` list. This allows you to always ensure that new checks present in the external source are used. If an external check is included in `--skip-check`, it will still be skipped.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| `-s, --soft-fail`                                                                                                                                                                                                                                                                                                                                                          | Runs checks but always returns a 0 exit code. Using either `--soft-fail-on` and / or `--hard-fail-on` overrides this option, except for the case when a result does not match either of the soft fail or hard fail criteria, in which case this flag determines the result.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `--soft-fail-on SOFT_FAIL_ON`                                                                                                                                                                                                                                                                                                                                              | Exits with a 0 exit code if only the specified items fail. Enter one or more items separated by commas. Each item may be either a Checkov check ID(CKV_AWS_123), a BC check ID (BC_AWS_GENERAL_123), or a severity (LOW, MEDIUM, HIGH, CRITICAL). If you use a severity, then any severity equal to or less than the highest severity in the list will result in a soft fail. This option may be used with `--hard-fail-on`, using the same priority logic described in `--check` and `--skip-check` options above, with `--hard-fail-on` taking precedence in a tie. If a given result does not meet the `--soft-fail-on` nor the `--hard-fail-on` criteria, then the default is to hard fail.                                                                                                                                                                                                                                                                                          |
| `--hard-fail-on HARD_FAIL_ON`                                                                                                                                                                                                                                                                                                                                              | Exits with a non-zero exit code for specified checks. Enter one or more items separated by commas. Each item may be either a Checkov check ID (CKV_AWS_123), a BCcheck ID (BC_AWS_GENERAL_123), or a severity (LOW, MEDIUM, HIGH, CRITICAL). If you use a severity, then any severity equal to or greater than the lowest severity in the list will result in a hard fail. This option can be used with `--soft-fail-on`, using the same priority logic described in `--check` and `--skip-check` options above, with `--hard-fail-on` taking precedence in a tie.                                                                                                                                                                                                                                                                                                                                                                                                                       |
| `--bc-api-key BC_API_KEY`                                                                                                                                                                                                                                                                                                                                                  | Prisma Cloud Access Key (see `--prisma-api-url`) [env var: BC_API_KEY]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `--prisma-api-url PRISMA_API_URL`                                                                                                                                                                                                                                                                                                                                          | The Prisma Cloud API URL (see:https://prisma.pan.dev/api/cloud/api-urls). Requires `--bc-api-key` to be a Prisma Cloud Access Key in the following format: `access_key_id::secret_key` [env var: PRISMA_API_URL]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| `--skip-results-upload`                                                                                                                                                                                                                                                                                                                                                    | Do not upload scan results to the platform. Use this to download configs, but only view results in the local output.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `--image, --docker-image DOCKER_IMAGE`                                                                                                                                                                                                                                                                                                                                     | Scan docker images by name or ID. Only works with `--bc-api-key flag`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `--dockerfile-path DOCKERFILE_PATH`                                                                                                                                                                                                                                                                                                                                        | Path to the Dockerfile of the scanned docker image                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| `--repo-id REPO_ID`                                                                                                                                                                                                                                                                                                                                                        | Identity string of the repository, with form `repo_owner/repo_name`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `-b, --branch BRANCH`                                                                                                                                                                                                                                                                                                                                                      | Selected branch of the persisted repository. Only has effect when using the `--bc-api-key` flag                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `--skip-download`                                                                                                                                                                                                                                                                                                                                                          | Do not download any data from Prisma Cloud. This will omit doc links, severities, etc., as well as custom policies and suppressions if using an API token. Note: it will prevent BC platform IDs from being available in Checkov.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| `--use-enforcement-rules`                                                                                                                                                                                                                                                                                                                                                  | Use the Enforcement rules configured in the platform for hard/soft fail logic, where the matching enforcement rule (or the default rule if no match) determines the behavior: skip checks below soft-fail threshold, include checks equal to or above hard-fail threshold in hard-fail list, and include checks in between in soft-fail list. Overrides can be applied using `--check`, `--skip-check`, `--soft-fail`, `--soft-fail-on`, or `--hard-fail-on`, but the order of applying `--check` and `--skip-check` (as described under `--check`) still applies here. Requires BC or PC platform API key.                                                                                                                                                                                                                                                                                                                                                                              |
| `--download-external-modules DOWNLOAD_EXTERNAL_MODULES`                                                                                                                                                                                                                                                                                                                    | Download external terraform modules from public git repositories and terraform registry [env var:DOWNLOAD_EXTERNAL_MODULES]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `--var-file VAR_FILE`                                                                                                                                                                                                                                                                                                                                                      | Variable files to load in addition to the default files (see https://www.terraform.io/docs/language/values/variables.html#variable-definitions-tfvars-files). Currently only supported for source Terraform (.tf file), and Helm chart scans. Requires using `--directory`, not `--file`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `--external-modules-download-path EXTERNAL_MODULES_DOWNLOAD_PATH`                                                                                                                                                                                                                                                                                                          | Set the path for the download external terraform modules [env var: EXTERNAL_MODULES_DIR]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `--evaluate-variables EVALUATE_VARIABLES`                                                                                                                                                                                                                                                                                                                                  | Evaluate the values of variables and locals [env var:CKV_EVAL_VARS]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `-ca, --ca-certificate CA_CERTIFICATE`                                                                                                                                                                                                                                                                                                                                     | Custom CA certificate (bundle) file [env var:BC_CA_BUNDLE]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `--repo-root-for-plan-enrichment REPO_ROOT_FOR_PLAN_ENRICHMENT`                                                                                                                                                                                                                                                                                                            | Directory containing the HCL code used to generate a given plan file. Use with `-f`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `--config-file CONFIG_FILE`                                                                                                                                                                                                                                                                                                                                                | Path to the Checkov configuration YAML file                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `--create-config CREATE_CONFIG`                                                                                                                                                                                                                                                                                                                                            | Takes the current command line args and writes them out to a config file at the given path                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `--show-config`                                                                                                                                                                                                                                                                                                                                                            | Prints all args and config settings and where they came from (e.g., command line, config file, environment variable or default)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `--create-baseline`                                                                                                                                                                                                                                                                                                                                                        | Alongside outputting the findings, save all results to .checkov.baseline file so future runs will not re-flag the same noise. Works only with `--directory` flag                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| `--baseline BASELINE`                                                                                                                                                                                                                                                                                                                                                      | Use a .checkov.baseline file to compare current results with a known baseline. Report will include only failed checks that are new with respect to the provided baseline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `--output-baseline-as-skipped`                                                                                                                                                                                                                                                                                                                                             | Output checks that are skipped due to baseline file presence                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| `--skip-cve-package SKIP_CVE_PACKAGE`                                                                                                                                                                                                                                                                                                                                      | Filter scan to run on all packages but a specific package identifier (deny list), You can specify this argument multiple times to skip multiple packages                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `--policy-metadata-filter POLICY_METADATA_FILTER`                                                                                                                                                                                                                                                                                                                          | Comma separated key:value string to filter policies based on Prisma Cloud policy metadata. See https://prisma.pan.dev/api/cloud/cspm/policy#operation/get-policy-filters-and-options for information on allowed filters. Format: policy.label=test,cloud.type=aws. [env var: CKV_POLICY_METADATA_FILTER]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| `--policy-metadata-filter-exception POLICY_METADATA_FILTER_EXCEPTION`                                                                                                                                                                                                                                                                                                                          | Comma separated key:value string to exclude filtered policies based on Prisma Cloud policy metadata. When used with --policy-metadata-filter, the exceptions override any policies selected as a result of the --policy-metadata-filter flag. [env var: CKV_POLICY_METADATA_FILTER_EXCEPTION]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| `--summary-position` {`top`, `bottom`}                                                                                                                                                                                                                                                                                                                                     | Choose whether the summary will be appended on top (before the checks results) or on bottom (after check results), default is on top.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `--no-fail-on-crash                            `                                                                                                                                                                                                                                                                                                                           | Return exit code 0 instead of 2 which indicates a failure in the integration with the platform                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `--enable-secret-scan-all-files CKV_SECRETS_SCAN_ENABLE_ALL`                                                                                                                                                                                                                                                                                                               | Enable secret scan to scan all type of file                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `--scan-secrets-history`                                                                                                                                                                                                                                                                                                                                                   | Enable secret scan history of commits                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `--block-list-secret-scan CKV_SECRETS_SCAN_BLOCK_LIST`                                                                                                                                                                                                                                                                                                                     | List of files to filter out in the secret scanner                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| `--support`                                                                                                                                                                                                                                                                                                                                                                | Enable debug logs and upload the logs to the server. Requires a Prisma Cloud API key.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `--custom-tool-name`                                                                                                                                                                                                                                                                                                                                                         | Add a custom tool name to change the tool name field, this is especially useful for outputting results in SARIF format for upload to Github Code Scanning                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |

### Environment variables
> **Note**: This is a subset of environment variables that we believe will be particularly helpful to users of Checkov. For more options, you can explore Checkov’s codebase—such as [this example location](https://github.com/bridgecrewio/checkov/blob/main/checkov/common/util/env_vars_config.py).


| Variable Name | Description | Default |
|-------------|----------------------------|----------------------------|
| `LOG_LEVEL` | Set the threshold of log levels for outputs. Using `LOG_LEVEL=debug` is useful for seeing logs for debugging issues around parsing, checks, graph rendering, etc.  | `WARNING` |
| `RENDER_EDGES_DUPLICATE_ITER_COUNT` | Set the threshold to break out of calculating duplicate edges in the graph. This can be determined if you see `Reached too many edge duplications...` in the Checkov logs. | `4` |
| `CHECKOV_OUTPUT_CODE_LINE_LIMIT` | Set the threshold for how long the code snippet can be and still show in the console output of Checkov. | `50` |
| `CHECKOV_EXPERIMENTAL_GRAPH_DEBUG` | Enables experimental log output for debugging graph policies. | `False` |
| `IGNORED_DIRECTORIES` | Comma-separated list of directories to ignore during scans.  | `node_modules,.terraform,.serverless` |
| `EVAL_TF_PLAN_AFTER_UNKNOWN` | Experimental feature to leverage the after_unknown section of plan files to determine if the check should pass or fail. | `False` |
| `CHECKOV_EXPERIMENTAL_TERRAFORM_MANAGED_MODULES` | Experimental feature to leverage the local cache of modules rather than downloading them. Requires terraform init before using. | `False` |
| `GITHUB_PAT`, `BITBUCKET_TOKEN`, `TF_REGISTRY_TOKEN`, `TF_HOST_NAME`, `VCS_BASE_URL`, `VCS_USERNAME`, `VCS_TOKEN` | See [Scanning Private Terraform Modules](https://www.checkov.io/7.Scan%20Examples/Terraform.html) for more details. |
| `ENABLE_CONFIG_FILE_VALIDATION` | If the conf-file explicitly set using the `--config-file` command does not exist, skip rather than throw an error (default) | `False` |
| `CHECKOV_MAX_IAC_FILE_SIZE` | Set the max size for CloudFormation file scans. | `50_000_000` or 50MB |
| `CHECKOV_MAX_FILE_SIZE` | Set the max file size for Secrets scans. | `5000000` or 5MB |
| `JAVA_FULL_DT` | Enables a deeper SCA scan for Java projects to resolve the full dependency tree, including transitive dependencies. | `False` |